(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     18498,        424]*)
(*NotebookOutlinePosition[     19150,        447]*)
(*  CellTagsIndexPosition[     19106,        443]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(f[x_] = \((6 - 2  x)\)/3\)], "Input"],

Cell[BoxData[
    \(1\/3\ \((6 - 2\ x)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{{Dashing[{0.01, 0.01}], Line[{{0, 2}, {3, 0}}], 
            Line[{{1.6, 0}, {1.6, f[1.6]}, {0, 
                  f[1.6]}}]}, \[IndentingNewLine]Text[a2, {1.45, 0.45}], 
          Text[a3, {0.8, f[1.6] - 0.15}], Text[a6, {0.15, 2.1}], 
          Text[a7, {3.1, 0.1}], 
          Line[{{1.6, 2.5}, {1.6, f[1.6]}, {3.5, f[1.6]}}]}, 
        Axes \[Rule] True, \ AxesStyle \[Rule] {Thickness[0.003]}, 
        Ticks \[Rule] None, PlotRange \[Rule] {{0, 3.5}, {0, 2.5}}, 
        AspectRatio \[Rule] Automatic]]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .71429 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.285714 5.55112e-017 0.285714 [
[ -0.0015 -0.0015 0 0 ]
[ 1.0015 .71579 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.003 w
[ ] 0 setdash
0 0 m
1 0 L
s
0 0 m
0 .71429 L
s
0 0 m
1 0 L
1 .71429 L
0 .71429 L
closepath
clip
newpath
.5 Mabswid
[ .01 .01 ] 0 setdash
0 .57143 m
.85714 0 L
s
.45714 0 m
.45714 .26667 L
0 .26667 L
s
gsave
.41429 .12857 -69 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a2) show
1.000 setlinewidth
grestore
gsave
.22857 .22381 -69 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a3) show
1.000 setlinewidth
grestore
gsave
.04286 .6 -69 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a6) show
1.000 setlinewidth
grestore
gsave
.88571 .02857 -69 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a7) show
1.000 setlinewidth
grestore
[ ] 0 setdash
.45714 .71429 m
.45714 .26667 L
1 .26667 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 205.688},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000cAP00`40o`000?l0003oo`0002000001
oooo00000`000?ooooooo`20oooo00<0003oooooool0KOooo`80000[oooo00000`000?ooooooo`20
oooo00<0003oooooool0K?ooo`030000oooooooo02_oool000030000oooooooo083oool00`000?oo
ooooo`1Zoooo00<0003oooooool0;Oooo`0000<0003oooooool0k?ooo`030000oooooooo02koool0
00030000oooooooo0>_oool00`000?ooooooo`0_oooo00000`000?ooooooo`20oooo00<0003ooooo
ool0V_ooo`0000<0003oooooool0P?ooo`030000oooooooo06Coool200003?ooo`D00003oooo00<0
003oooooool07Oooo`0000<0003oooooool0P?ooo`030000oooooooo06?oool00`000?ooooooo`0<
oooo100000Coool00`000?ooooooo`0Moooo00000`000?ooooooo`20oooo00<0003oooooool0MOoo
o`030000oooooooo00;oool00`000?ooooooo`0Moooo00000`000?ooooooo`3Soooo0P00017oool3
00001Oooo`030000oooooooo01coool000030000oooooooo0>7oool200006?ooo`040000oooooooo
00007_ooo`0000<0003oooooool0P?ooo`030000oooooooo07Soool400007_ooo`0000<0003ooooo
ool0P?ooo`030000oooooooo05coool00`000?ooooooo`0koooo00000`000?ooooooo`20oooo00<0
003oooooool0F_ooo`80000noooo00000`000?ooooooo`20oooo00<0003oooooool0FOooo`030000
oooooooo03koool000030000oooooooo0=[oool00`000?ooooooo`10oooo00000`000?ooooooo`20
oooo00<0003oooooool0E_ooo`030000oooooooo047oool000030000oooooooo083oool00`000?oo
ooooo`1Eoooo00<0003oooooool0@_ooo`0000<0003oooooool0P?ooo`030000oooooooo05;oool0
0`000?ooooooo`15oooo00000`000?ooooooo`20oooo00<0003oooooool0DOooo`030000oooooooo
04Koool000030000oooooooo0=?oool00`000?ooooooo`17oooo00000`000?ooooooo`3Aoooo00<0
003oooooool0BOooo`0000<0003oooooool0P?ooo`030000oooooooo04coool20000C?ooo`0000<0
003oooooool0P?ooo`030000oooooooo04_oool00`000?ooooooo`1<oooo00000`000?ooooooo`20
oooo00<0003oooooool0V_ooo`0000<0003oooooool0P?ooo`030000oooooooo04Soool20000D?oo
o`0000<0003oooooool0bOooo`80001Boooo00000`000?ooooooo`3ooooo7_ooo`0000<0003ooooo
ool0P?ooo`030000oooooooo04?oool20000EOooo`0000<0003oooooool0P?ooo`030000oooooooo
04;oool00`000?ooooooo`1Eoooo00000`000?ooooooo`20oooo00<0003oooooool0V_ooo`0000<0
003oooooool0P?ooo`030000oooooooo03ooool00`000?ooooooo`1Hoooo00000`000?ooooooo`31
oooo00<0003oooooool0FOooo`0000<0003oooooool0P?ooo`030000oooooooo03goool00`000?oo
ooooo`1Joooo00000`000?ooooooo`1_oooo1@000003oooo0000000000800007oooo00<0003ooooo
ool0>oooo`030000oooooooo05coool000030000oooooooo06ooool400000_ooo`030000oooooooo
00Soool00`000?ooooooo`0ioooo0P0005ooool000030000oooooooo07;oool01@000?oooooooooo
o`000009oooo00<0003oooooool0>?ooo`030000oooooooo05ooool000030000oooooooo073oool3
00001?ooo`030000oooooooo03ooool00`000?ooooooo`1Qoooo00000`000?ooooooo`1eoooo00@0
003oooooool0000ooooo00<0003oooooool0H_ooo`0000<0003oooooool0M_ooo`800008oooo00<0
003oooooool0=?ooo`030000oooooooo06?oool000030000oooooooo083oool00`000?ooooooo`0a
oooo00<0003oooooool0I_ooo`0000<0003oooooool0P?ooo`030000oooooooo033oool00`000?oo
ooooo`1Woooo00000`000?ooooooo`20oooo00<0003oooooool0;oooo`030000oooooooo06Soool0
00030000oooooooo0?oooolNoooo00000`000?ooooooo`2^oooo0P0006goool000030000oooooooo
083oool00`000?ooooooo`0Zoooo00<0003oooooool0KOooo`0000<0003oooooool0P?ooo`030000
oooooooo09[oool000030000oooooooo083oool00`000?ooooooo`0Woooo0P00077oool000030000
oooooooo083oool00`000?ooooooo`0Uoooo0P0007?oool000030000oooooooo0?oooolNoooo0000
0`000?ooooooo`2Uoooo0P0007Koool000030000oooooooo083oool00`000?ooooooo`0Qoooo00<0
003oooooool0M_ooo`0000<0003oooooool0P?ooo`030000oooooooo09[oool000030000oooooooo
083oool00`000?ooooooo`0Noooo00<0003oooooool0NOooo`0000<0003oooooool0X?ooo`030000
oooooooo07[oool000030000oooooooo09ooool00`000?ooooooo`1koooo00000`000?ooooooo`20
oooo00<0003oooooool06Oooo`030000oooooooo07koool000030000oooooooo083oool00`000?oo
ooooo`0Hoooo00<0003oooooool0Ooooo`0000<0003oooooool0P?ooo`030000oooooooo01Ooool0
0`000?ooooooo`20oooo00000`000?ooooooo`20oooo00<0003oooooool05Oooo`030000oooooooo
08;oool000030000oooooooo09Koool20000QOooo`0000<0003oooooool0UOooo`030000oooooooo
08Goool000030000oooooooo03[oool500000_ooo`80000moooo00<0003oooooool0V_ooo`0000<0
003oooooool0>_ooo`@00002oooo00@0003oooooool0000loooo00<0003oooooool03oooo`800029
oooo00000`000?ooooooo`0moooo00<0003oooooool00_ooo`030000oooooooo03_oool00`000?oo
ooooo`0>oooo00<0003oooooool0ROooo`0000<0003oooooool0>oooo`<00005oooo00<0003ooooo
ool0>_ooo`030000oooooooo09[oool000030000oooooooo043oool010000?ooooooo`0004Woool2
0000S_ooo`0000<0003oooooool0@Oooo`800019oooo00<0003oooooool0S_ooo`0000<0003ooooo
ool0P?ooo`030000oooooooo09[oool000030000oooooooo083oool00`000?ooooooo`05oooo0P00
09?oool000030000oooooooo083oool00`000?ooooooo`04oooo00<0003oooooool0Toooo`0000<0
003oooooool0P?ooo`030000oooooooo09[oool000030000oooooooo08Goool00`000?ooooooo`2E
oooo00000`000?ooooooo`20oooo00<0003oooooool00P0009Soool000030000oooooooo083oool0
0`000?ooo`00002Joooo000200000_ooo`@00002oooo100000;oool4000000?oool0000000000P00
00;oool400000_ooo`@00002oooo0`0000;oool400000_ooo`@00002oooo0`0000;oool400000_oo
o`@00002oooo10000003oooo0000000000800002oooo100000;oool400000_ooo`<00002oooo1000
00;oool400000_ooo`@000000oooo`000000000200000_ooo`@00002ooooW@00007oool000030000
oooooooo07ooool20000W?ooo`0000<0003oooooool0O_ooo`030000oooo000009coool000030000
oooooooo07_oool00`000?ooooooo`02oooo00<0003oooooool0V_ooo`0000<0003oooooool0N_oo
o`030000oooooooo00?oool00`000?ooooooo`2Joooo00000`000?ooooooo`1ioooo00<0003ooooo
ool01?ooo`030000oooooooo09[oool000030000oooooooo083oool00`000?ooooooo`2Joooo0000
0`000?ooooooo`1eoooo0P0000Woool00`000?ooooooo`2Joooo00000`000?ooooooo`1doooo00<0
003oooooool02Oooo`030000oooooooo09[oool000030000oooooooo083oool00`000?ooooooo`2J
oooo00000`000?ooooooo`1aoooo0P0000goool00`000?ooooooo`2Joooo00000`000?ooooooo`1_
oooo0P0000ooool00`000?ooooooo`2Joooo00000`000?ooooooo`20oooo00<0003oooooool0V_oo
o`0000<0003oooooool0K?ooo`80000Boooo00<0003oooooool0V_ooo`0000<0003oooooool0Jooo
o`030000oooooooo01;oool00`000?ooooooo`2Joooo00000`000?ooooooo`20oooo00<0003ooooo
ool0V_ooo`0000<0003oooooool0J?ooo`030000oooooooo01Goool00`000?ooooooo`2Joooo0000
0`000?ooooooo`1Woooo00<0003oooooool05_ooo`030000oooooooo09[oool000030000oooooooo
06Koool00`000?ooooooo`0Goooo00<0003oooooool0V_ooo`0000<0003oooooool0Hoooo`030000
oooooooo01[oool00`000?ooooooo`2Joooo00000`000?ooooooo`1Roooo00<0003oooooool06ooo
o`030000oooooooo09[oool000030000oooooooo067oool00`000?ooooooo`0Loooo00<0003ooooo
ool0V_ooo`0000<0003oooooool0Goooo`030000oooooooo01koool00`000?ooooooo`2Joooo0000
0`000?ooooooo`1Moooo0P00027oool00`000?ooooooo`2Joooo00000`000?ooooooo`1Loooo00<0
003oooooool08Oooo`030000oooooooo09[oool000030000oooooooo083oool00`000?ooooooo`2J
oooo00000`000?ooooooo`1Ioooo0P0002Goool00`000?ooooooo`2Joooo00000`000?ooooooo`1H
oooo00<0003oooooool09Oooo`030000oooooooo09[oool000030000oooooooo083oool00`000?oo
ooooo`2Joooo00000`000?ooooooo`1Doooo0P0002[oool00`000?ooooooo`2Joooo00000`000?oo
ooooo`1Coooo00<0003oooooool0:_ooo`030000oooooooo09[oool000030000oooooooo083oool0
0`000?ooooooo`2Joooo00000`000?ooooooo`1?oooo0P0002ooool00`000?ooooooo`2Joooo0000
0`000?ooooooo`1>oooo00<0003oooooool0;oooo`030000oooooooo09[oool000030000oooooooo
083oool00`000?ooooooo`2Joooo00000`000?ooooooo`1<oooo00<0003oooooool0<Oooo`030000
oooooooo09[oool000030000oooooooo04[oool20000=?ooo`030000oooooooo09[oool000030000
oooooooo04Woool00`000?ooooooo`0doooo00<0003oooooool0V_ooo`0000<0003oooooool0Aooo
o`030000oooooooo03Koool00`000?ooooooo`2Joooo00000`000?ooooooo`16oooo00<0003ooooo
ool0=oooo`030000oooooooo09[oool000030000oooooooo04Goool00`000?ooooooo`0hoooo00<0
003oooooool0V_ooo`0000<0003oooooool0@_ooo`030000oooooooo03_oool00`000?ooooooo`2J
oooo00000`000?ooooooo`11oooo00<0003oooooool0??ooo`030000oooooooo09[oool000030000
oooooooo043oool00`000?ooooooo`0moooo00<0003oooooool0V_ooo`0000<0003oooooool0P?oo
o`030000oooooooo09[oool000030000oooooooo03coool20000@_ooo`030000oooooooo09[oool0
00030000oooooooo03_oool00`000?ooooooo`12oooo00<0003oooooool0V_ooo`0000<0003ooooo
ool0P?ooo`030000oooooooo09[oool000030000oooooooo03Soool20000A_ooo`030000oooooooo
09[oool000030000oooooooo03Koool20000B?ooo`030000oooooooo09[oool000030000oooooooo
083oool00`000?ooooooo`2Joooo00000`000?ooooooo`0coooo0P0004_oool00`000?ooooooo`2J
oooo00000`000?ooooooo`0boooo00<0003oooooool0Boooo`030000oooooooo09[oool000030000
oooooooo083oool00`000?ooooooo`2Joooo00000`000?ooooooo`0_oooo00<0003oooooool0C_oo
o`030000oooooooo09[oool000030000oooooooo02koool00`000?ooooooo`1?oooo00<0003ooooo
ool0V_ooo`0000<0003oooooool0;Oooo`030000oooooooo053oool00`000?ooooooo`2Joooo0000
0`000?ooooooo`0Zoooo00<0003oooooool0Doooo`030000oooooooo09[oool000030000oooooooo
02Woool00`000?ooooooo`1Doooo00<0003oooooool0V_ooo`0000<0003oooooool0:?ooo`030000
oooooooo05Goool00`000?ooooooo`2Joooo00000`000?ooooooo`0Voooo00<0003oooooool0Eooo
o`030000oooooooo09[oool000030000oooooooo02Coool20000F_ooo`030000oooooooo09[oool0
00030000oooooooo02?oool00`000?ooooooo`1Joooo00<0003oooooool0V_ooo`0000<0003ooooo
ool0P?ooo`030000oooooooo09[oool000030000oooooooo023oool20000G_ooo`030000oooooooo
09[oool000030000oooooooo01ooool00`000?ooooooo`1Noooo00<0003oooooool0V_ooo`0000<0
003oooooool0P?ooo`030000oooooooo09[oool000030000oooooooo01_oool20000Hoooo`030000
oooooooo09[oool000030000oooooooo01[oool00`000?ooooooo`1Soooo00<0003oooooool0V_oo
o`0000<0003oooooool0P?ooo`030000oooooooo09[oool000030000oooooooo01Koool20000J?oo
o`030000oooooooo09[oool000030000oooooooo01Goool00`000?ooooooo`1Xoooo00<0003ooooo
ool0V_ooo`0000<0003oooooool0P?ooo`030000oooooooo09[oool000030000oooooooo01?oool0
0`000?ooooooo`1Zoooo00<0003oooooool0V_ooo`0000<0003oooooool04Oooo`80001]oooo00<0
003oooooool0V_ooo`0000<0003oooooool04?ooo`030000oooooooo06goool00`000?ooooooo`2J
oooo00000`000?ooooooo`0>oooo00<0003oooooool0Koooo`030000oooooooo09[oool000030000
oooooooo00goool00`000?ooooooo`1`oooo00<0003oooooool0V_ooo`0000<0003oooooool03?oo
o`030000oooooooo077oool00`000?ooooooo`2Joooo00000`000?ooooooo`09oooo00<0003ooooo
ool0M?ooo`030000oooooooo09[oool000030000oooooooo00Soool00`000?ooooooo`1eoooo00<0
003oooooool0V_ooo`0000<0003oooooool01oooo`030000oooooooo07Koool00`000?ooooooo`2J
oooo00000`000?ooooooo`20oooo00<0003oooooool0V_ooo`0000<0003oooooool00oooo`80001k
oooo00<0003oooooool0V_ooo`0000<0003oooooool00_ooo`030000oooooooo07_oool00`000?oo
ooooo`2Joooo00000`000?ooooooo`20oooo00<0003oooooool0V_ooo`0000@0003oool00000001o
oooo00<0003oooooool0V_ooo`000P00087oool00`000?ooooooo`2Joooo00000`000?ooooooo`20
oooo00<0003oooooool0V_ooo`0000<0003oooooool0P?ooo`030000oooooooo09[oool000030000
oooooooo083oool00`000?ooooooo`2Joooo00000`000?ooooooo`20oooo00<0003oooooool0V_oo
o`0000<0003oooooool0P?ooo`030000oooooooo09[oool000030000oooooooo083oool00`000?oo
ooooo`2Joooo00000`000?ooooooo`05oooo1@000004oooo000000000000L_ooo`030000oooooooo
09[oool000030000oooooooo00Goool400000_ooo`040000oooooooo0000LOooo`030000oooooooo
09[oool000030000oooooooo00Soool010000?ooooooo`0000;oool00`000?ooooooo`1_oooo00<0
003oooooool0V_ooo`0000<0003oooooool01_ooo`<00002oooo0`0007;oool00`000?ooooooo`2J
oooo00000`000?ooooooo`0<oooo00<0003oooooool0LOooo`030000oooooooo09[oool000030000
oooooooo00coool30000LOooo`030000oooooooo09[oool000030000oooooooo083oool00`000?oo
ooooo`2Joooo00000`000?ooooooo`20oooo00<0003oooooool0V_ooo`0000<0003oooooool0P?oo
o`030000oooooooo09[oool000030000oooooooo083oool00`000?ooooooo`2Joooo00000`000?oo
ooooo`20oooo00<0003oooooool0V_ooo`0000<0003oooooool0P?ooo`030000oooooooo09[oool0
00030000oooooooo083oool00`000?ooooooo`2Joooo00000`000?ooooooo`20oooo00<0003ooooo
ool0V_ooo`0000<0003oooooool0P?ooo`030000oooooooo09[oool000030000oooooooo083oool0
0`000?ooooooo`2Joooo00000`000?ooooooo`20oooo00<0003oooooool0V_ooo`0000<0003ooooo
ool0P?ooo`030000oooooooo09[oool000030000oooooooo083oool00`000?ooooooo`2Joooo0000
0`000?ooooooo`20oooo00<0003oooooool0V_ooo`0000<0003oooooool0P?ooo`030000oooooooo
09[oool000030000oooooooo083oool00`000?ooooooo`2Joooo00000`000?ooooooo`20oooo00<0
003oooooool0V_ooo`0000<0003oooooool0P?ooo`030000oooooooo09[oool000030000oooooooo
083oool00`000?ooooooo`2Joooo00000`000?ooooooo`20oooo00<0003oooooool0V_ooo`0000<0
003oooooool0P?ooo`030000oooooooo09[oool000030000oooooooo083oool00`000?ooooooo`2J
oooo00000`000?ooooooo`20oooo00<0003oooooool0V_ooo`0000<0003oooooool0P?ooo`030000
oooooooo09[oool000030000oooooooo083oool00`000?ooooooo`2Joooo00000`000?ooooooo`20
oooo00<0003oooooool0V_ooo`0000<0003oooooool0P?ooo`030000oooooooo09[oool000030000
oooooooo083oool00`000?ooooooo`2Joooo00000`000?ooooooo`20oooo00<0003oooooool0V_oo
o`00\
\>"],
  ImageRangeCache->{{{0, 287}, {204.688, 0}} -> {-0.0100611, -0.00526256, \
0.0122652, 0.0122652}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Display["\<escalera.eps\>", \ %, \ "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{792, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 57, 1, 30, "Input"],
Cell[1799, 54, 54, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[1890, 60, 563, 10, 150, "Input"],
Cell[2456, 72, 15645, 333, 214, 3244, 175, "GraphicsData", "PostScript", \
"Graphics"],
Cell[18104, 407, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18271, 415, 78, 1, 30, "Input"],
Cell[18352, 418, 130, 3, 29, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

